# 説明会予約システム

介護施設の説明会予約を管理するWebアプリケーションです。

## 機能概要

### ユーザー機能
- 施設選択（プルダウン）
- カレンダー表示での日付選択
- 時間帯選択（ラジオボタン）
- 予約申込フォーム
- 確認画面・完了画面
- 自動メール通知

### 管理者機能
- 予約一覧表示
- 予約承認/拒否
- 予約詳細確認
- 承認時自動メール送信

## セットアップ手順

### 1. 必要な環境
- Node.js (v14以上)
- MySQL (v8.0以上)
- SMTP対応メールアカウント

### 2. インストール
```bash
npm install
```

### 3. データベース設定
```bash
# MySQLにログイン
mysql -u root -p

# データベース作成
CREATE DATABASE reservation_system;
USE reservation_system;

# テーブル作成
source database.sql
```

### 4. 環境変数設定
`.env`ファイルを作成し、以下を設定：
```env
EMAIL_USER=your-email@gmail.com
EMAIL_PASS=your-app-password
DB_HOST=localhost
DB_USER=root
DB_PASS=your-password
DB_NAME=reservation_system
```

### 5. 起動
```bash
# 開発環境
npm run dev

# 本番環境  
npm start
```

## 使用方法

### ユーザー側
1. http://localhost:3001 にアクセス
2. 施設をプルダウンから選択
3. カレンダーで○がついた日付をクリック
4. 時間帯をラジオボタンで選択
5. 申込フォームに必要事項を入力
6. 確認画面で内容を確認し送信

### 管理者側
1. http://localhost:3001/admin にアクセス
2. ログイン（初期: admin / admin123）
3. 予約一覧で承認待ちを確認
4. 「承認」または「拒否」ボタンをクリック
5. 承認時は自動でメール送信

## データベース構造

### facilities（施設）
- あさくら苑 / あさくら苑デイサービスセンター
- あさくら苑デイサービスセンター  
- リバティーハウスあさくら

### schedules（スケジュール）
- 施設、日付、時間帯、定員管理

### reservations（予約）
- 申込者情報、承認ステータス管理

### admins（管理者）
- 管理者アカウント情報

## フォーム項目

### 必須項目
- 名前
- よみがな
- メールアドレス
- 年齢
- 最終学歴
- 志望動機

### 任意項目
- その他（備考）

## メール機能
- 申込完了時：申込者へ確認メール
- 承認時：申込者へ確定メール
- Gmail SMTP使用（要アプリパスワード設定）

## 技術構成
- **Backend**: Node.js + Express
- **Database**: MySQL
- **Frontend**: HTML + CSS + JavaScript (Vanilla)
- **Template**: EJS
- **Mail**: Nodemailer

## カスタマイズ

### 施設追加
`database.sql`のfacilitiesテーブルにINSERT

### スケジュール追加
schedulesテーブルに新しい時間帯を追加

### メールテンプレート変更
`server.js`の`sendConfirmationEmail`と`sendApprovalEmail`関数を編集

## セキュリティ
- 管理者パスワードはbcryptでハッシュ化
- セッション管理実装
- SQLインジェクション対策

## 注意事項
- 本番環境では環境変数でDB接続情報を設定
- SSL/HTTPS推奨
- メール送信にはGmailアプリパスワード必要